; PLUGIN STEP 10: VISUALIZATION METHOD

(defmeth vista-loglinear-proto :visualize ()
    (setf container (make-container :free t :type 1 :local-menus t :show nil))
  (enable-container container)
  (let*
    (
     (v-log-lin-proto self)
     (terms (expand-hierarchy 
                (list (iseq (length (send self :vars))))))
     (terms-cat (send self :list-terms))
     (terms-in-model-name-list 
      (name-list 
       (mapcar 'princ-to-string terms-cat) :show nil))
     (obs-list
      (name-list 
       (mapcar 'princ-to-string (send self :sorted-labels))
       :color 'blue))
     (number-vars (length (send self :vars)))
     (use-mosaic-plot? (if (or (>  (reduce '* (send self :ncat)) 96)(> number-vars 4)) nil t))
     (mp (when use-mosaic-plot?
             (mosaic-plot (send self :counts)
                          (send self :ncat)  
             :legend2 "Mosaic plot of Observed data"             
                          :freq t 
                          :connect-button t
                          :color-values (send (send self :curr-model) :adj-chi-residuals)
                          :way-labels (send self :vars)
                          :level-labels (mapcar #'sort-data (send self :level-labels))
                          :standardize nil
                          :show nil)))
     (mp-predicted 
      (when use-mosaic-plot?
            (mosaic-plot (exp (send (send self :curr-model) :fit-values))
                          (send self :ncat)   
             :legend2 "Mosaic plot of Predicted data"            
                          :freq t 
                          :connect-button t
                          :color-values (send (send self :curr-model) :adj-chi-residuals)
                          :way-labels (send self :vars)
                          :level-labels (mapcar #'sort-data (send self :level-labels))
                          :standardize nil
                          :show nil)))
     (count-residual (plot-points 
                      (send self :counts)
                      (send (send self :curr-model)
                            :adj-chi-residuals)
                      
                      :variable-labels (list "Raw Frequencies" "Adj-chi-residuals")
                                 :color 'blue 
                      :show nil))
     (resplot (plot-points (exp (send (send self :curr-model) :fit-values))
                           (send (send self :curr-model)
                                 :adj-chi-residuals)
                           
                           :variable-labels (list "Predicted" "Adj-chi-residuals")
                           :color 'blue 
                           :legend2 "Predicted-Residual Plot"
                           :show nil))
     (cook-plot (plot-points (send (send self :curr-model) :leverages)
                             (send (send self :curr-model)
                                   :cooks-distances)
                             :variable-labels (list "Leverages" "Cooks distances")
                             
                             :color 'blue :show nil))
     (dev-plot (plot-points (list 1) 
                            (list (send (send self :curr-model)
                                        :chi) )
                            :variable-labels (list "Model" "Chi-square/df")
                            :show nil))
     (par-plot (send self :parametters-plot))
     (w (send display-window-proto2 :new :pop-out-on-show t :show nil ))
     )
    (mapcar #'(lambda (plot)
                (send plot :point-label (iseq (send plot :num-points)) 
                      (send self :sorted-labels))
                (send plot :plot-buttons :new-x nil :new-y nil)
                )
           (list resplot count-residual cook-plot))
    (send dev-plot :plot-buttons  :new-x nil :new-y nil)
            (send dev-plot :x-axis t t 0)
    (send cook-plot :range 0 0 1)
     (defmeth cook-plot :add-limit-lines ()
      (let* ((ncat (length (send v-log-lin-proto :counts)))
             (lim-lev (/ (send (send v-log-lin-proto :curr-model) 
                                 :num-coefs)
                         ncat))
             (max-cook (max (send (send v-log-lin-proto :curr-model)  :cooks-distances)))
             (lim-cook (/  ncat 4))
             )
          (send self :clear-lines)
        (send self :range 1 0 (max max-cook lim-cook))
          (send self  :add-lines (list lim-lev lim-lev) 
                (list 0 (max max-cook lim-cook)) :color 'orange)
          (send self :add-lines (list 0 1) (list lim-cook lim-cook) :color 'orange))
      )
    (send cook-plot :add-limit-lines)
    (if 
     (= (length (send self :terms)) 1)
     (send terms-in-model-name-list :selection 
           (iseq (length (combine (send self :terms)))))
     (send terms-in-model-name-list :selection (combine (last (send self :terms)))))
    (send terms-in-model-name-list :has-h-scroll t)

    (send dev-plot :legend2 "Chi-Square Plot")
  (send cook-plot :legend2 "Influence Plot")
    (send resplot :legend2 "Predicted-Residual Plot")
    (send count-residual  :legend2 "Observed-Residual Plot") 

    (setf be-h-menu-item  
          (send menu-item-proto :new "Be Non-Hierarchical" 
                :action #'(lambda () 
                            (send v-log-lin-proto :be-hierarchic?
                                  (if (send v-log-lin-proto :be-hierarchic?) 
                                      nil t))
                            (send be-h-menu-item :update))))
                            
    (defmeth be-h-menu-item :update ()
      (if (send v-log-lin-proto :be-hierarchic?) 
                                (send self :title "Be Non-Hierarchical")
                                (send self :title "Be Hierarchical")))
      
   (send
    (send terms-in-model-name-list :menu) :append-items be-h-menu-item)
    (send v-log-lin-proto :be-hierarchic? t)
   (send obs-list :has-h-scroll t)
    (defmeth dev-plot :redraw ()
      (call-next-method)
      (send self :abline 1 0 :color 'green))
   (defmeth terms-in-model-name-list :do-select-click (x y m1 m2)
     
     (setf bhierarchic (send v-log-lin-proto :be-hierarchic?));hay que cambiar esto
           (cond 
                   (bhierarchic
                    (when m1
                          (setf prev-selected (send self :selection))
                          (send self :start-buffering)
                          (when (and prev-selected m1) (send self :selection (list nil)))
                          )
                    (call-next-method x y m1 m2)
                    (when (send self :selection)
                          (when m1
                                (setf post-selected (send self :selection))
                                (send self :selection 
                                      (set-difference (combine prev-selected post-selected)
                                                      (intersection prev-selected post-selected)))
                                (send self :redraw)
                                (send self :buffer-to-screen)
                                )


                    (let* (
                           (list-terms
                            (combine (mapcar #'(lambda (term) 
                                                 (which (mapcar #'(lambda (term2) 
                                                                    (equal term term2))
                                                                terms)))
                                             (expand-hierarchy 
                                              (select terms (send self :selection))))))
                           (terms-in-model (expand-hierarchy
                                              (select terms (send self :selection))))
                           )

                      (send self :selection list-terms)


                      (send v-log-lin-proto :terms (append (send v-log-lin-proto :terms) 
                                                      (list list-terms)))
                      (send v-log-lin-proto :models-adjusted-list
                            (combine
                             (send v-log-lin-proto :models-adjusted-list)
                             (log-linear-model (send v-log-lin-proto :ncat)
                                               (send v-log-lin-proto :counts)
                                               terms-in-model
                                               (send v-log-lin-proto :vars)
                                               (mapcar #'sort-data (send v-log-lin-proto :level-labels))
                                               (send v-log-lin-proto :data-matrix)
                                               (send v-log-lin-proto :excluded-categories)
                                               )))
              
                      (send v-log-lin-proto :model 
                            (append (send v-log-lin-proto :model) 
                                    (list (select (send v-log-lin-proto :list-terms) 
                                                  list-terms))))
                   (send v-log-lin-proto :curr-model 
                         (car (reverse (send v-log-lin-proto :models-adjusted-list))))
                   
                   (send (send self :spreadplot-object)
                         :update-spreadplot "terms" 0 
                         (send self :selection))
                      )))
                  
                  (t
                   (when m1
                         (setf prev-selected (send self :selection))
                         (send self :start-buffering)
                         (when (and prev-selected m1) (send self :selection (list nil)))
                         )
                   (call-next-method x y m1 m2)
                   (when (send self :selection)
                   (when m1
                         (setf post-selected (send self :selection))
                         (send self :selection 
                               (set-difference (combine prev-selected post-selected)
                                               (intersection prev-selected post-selected)))
                         )
                   (send v-log-lin-proto :terms (append (send v-log-lin-proto :terms) 
                                                   (list (send self :selection))))
              
                   (send v-log-lin-proto :models-adjusted-list
                         (combine
                          (send v-log-lin-proto :models-adjusted-list)
                          (log-linear-model (send v-log-lin-proto :ncat)
                                            (send v-log-lin-proto :counts)
                                            (select terms (send self :selection))
                                            (send v-log-lin-proto :vars)
                                            (mapcar #'sort-data (send v-log-lin-proto :level-labels))
                                            (send v-log-lin-proto :data-matrix)
                                            (send v-log-lin-proto :excluded-categories)
                                            )))
              
                   (send v-log-lin-proto :model (append (send v-log-lin-proto :model) 
                                                        (list (select 
                                                               (send v-log-lin-proto :list-terms) 
                                                               (send self :selection)))))
                   (send v-log-lin-proto :curr-model 
                         (car (reverse (send v-log-lin-proto :models-adjusted-list))))
 
                   (send (send self :spreadplot-object)
                         :update-spreadplot "terms" 0 (send self :selection))))
             )
     (send self :buffer-to-screen)
     (send self :redraw))
     
    (defmeth terms-in-model-name-list :update-plotcell (&rest args)
      (when (equal (first args) "dev-plot")
       (when (= (length (combine (third args))) 1)
                      (send self :selection 
                                             (combine (select
                                               (send v-log-lin-proto :terms)
                                               (first (third args))
                                                       )))))
           )




    (defmeth resplot :update-plotcell (&rest args)
      (send self :start-buffering)
      (cond
        ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
         (send self :my-new-plot (exp (send (send v-log-lin-proto :curr-model) :fit-values))
               (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals) )
                 )
        ((equal (first args) "terms")
         (send self :my-new-plot (exp (send (send v-log-lin-proto :curr-model) :fit-values))
             (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals))))
      (send self :adjust-to-data)
            (if (> (max (mapcar 'abs (send self :range 1))) 3)
          (send self :adjust-to-data)
          (send self :range 1 -3 3))
      (send self :buffer-to-screen)
      )
   (when use-mosaic-plot?
         (defmeth mp :update-plotcell (&rest args)
           (send self :my-new-plot
                 (if (send v-log-lin-proto :use-logs?)
                     (sqrt (send v-log-lin-proto :counts))
                     (send v-log-lin-proto :counts))
                    
                 (send v-log-lin-proto :ncat)
                 :color-values
                 (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals)
                 :standardize nil 
                 :level-labels (mapcar #'sort-data (send v-log-lin-proto :level-labels))
                 :way-labels (send v-log-lin-proto :vars)))
         (defmeth mp-predicted :update-plotcell (&rest args)
           (send self :my-new-plot
                 (if (send v-log-lin-proto :use-logs?)
                     (sqrt (exp (send (send v-log-lin-proto :curr-model) :fit-values)))
                     (exp (send (send v-log-lin-proto :curr-model) :fit-values)))
                 (send v-log-lin-proto :ncat)
                 :color-values
                 (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals)
                 :standardize nil 
                 :level-labels (mapcar #'sort-data (send v-log-lin-proto :level-labels))
                 :way-labels (send v-log-lin-proto :vars)))

         )

    (defmeth count-residual :update-plotcell (&rest args)
      (send self :start-buffering)
      (cond
        ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
         (send self :my-new-plot (send v-log-lin-proto  :counts)
               (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals) )
                 )
        ((equal (first args) "terms")
         (send self :my-new-plot (send v-log-lin-proto :counts)
             (send (send v-log-lin-proto :curr-model)  :adj-chi-residuals))))
      (send self :adjust-to-data)
            (if (> (max (mapcar 'abs (send self :range 1))) 3)
          (send self :adjust-to-data)
          (send self :range 1 -3 3))
      (send self :buffer-to-screen)
      )

   

    (defmeth cook-plot :update-plotcell (&rest args)
      (send self :start-buffering)
      (let (
            (leverages (send (send v-log-lin-proto :curr-model) :leverages))
            (cook-dist  (send (send v-log-lin-proto :curr-model)  :cooks-distances))
            )
      (cond
        ((and (equal (first args) "dev-plot") (= (length (combine (third args))) 1))
         (send self :my-new-plot leverages
         cook-dist))
         
         
        ((equal (first args) "terms")
         (send self :my-new-plot (send (send v-log-lin-proto :curr-model) :leverages)
               (send (send v-log-lin-proto :curr-model)  :cooks-distances))
               ))
        (send self :adjust-to-data)
        (send self :add-limit-lines)


      (send self :range 0 0 1)
        (send self :buffer-to-screen)
        ))

    (defmeth w :update-plotcell (&rest args)
      (let* (
             (args args)
             (selection (combine (third args)))
             )
        (send self :flush-window)
      (cond 
             ((equal (first args) "terms")
              (let* (
                     (dev (send 
                           (send v-log-lin-proto :curr-model)  
                           :deviance))
                     (df (- (apply '* (send v-log-lin-proto :ncat))
                                 (send
                                  (send v-log-lin-proto :curr-model) 
                                 :num-coefs)))
                     (p (- 1 (if (= df 0) 0 (chisq-cdf dev df)))))
               (add-text w 
                           (format nil "Deviance= ~,5g df=  ~d p= ~,5f "
                            dev df p))
                                   )
              )
             ((equal (first args) "dev-plot")

              (cond 
                ((= (length selection) 1)
                 (let* (
                        (dev (send 
                              (send v-log-lin-proto :curr-model)  
                              :deviance))
                        (df (- (apply '* (send v-log-lin-proto :ncat))
                               (send
                                (send v-log-lin-proto :curr-model) 
                                :num-coefs)))
                        (p (- 1 (if (= df 0) 0 (chisq-cdf dev df))))
                        (cur-model (car
                                    (select
                                     (send v-log-lin-proto :models-adjusted-list) 
                                     selection))))
                   
                 (add-text w 
                           (format nil "Deviance ~,5g df=  ~d p= ~,5f ~%AIC ~,5g ~%BIC ~,5g"
                                   dev
                                   df
                                   p
                                   (send cur-model :aic)
                                   (send cur-model :bic)))
                           ))
                ((= (length selection) 2)
                 (send self :flush-window)
                 (cond   ((send v-log-lin-proto :nested-model? 
                                (select
                                 (send v-log-lin-proto :terms) 
                                     (first selection))
                                (select
                                 (send v-log-lin-proto :terms) 
                                 (second selection)))
                          (let* (
                                (first-dev (send
                                               (select
                                                (send v-log-lin-proto :models-adjusted-list) 
                                                (first selection))
                                               :deviance))
                                (second-dev  (send 
                                               (select
                                                (send v-log-lin-proto :models-adjusted-list) 
                                                (second selection))
                                               :deviance))
                                (first-coefs (send 
                                               (select
                                                (send v-log-lin-proto :models-adjusted-list) 
                                                (first selection))
                                               :num-coefs))
                                (second-coefs (send 
                                               (select
                                                (send v-log-lin-proto :models-adjusted-list) 
                                                (second selection))
                                               :num-coefs))
                                 (dif (- first-dev second-dev))
                                 (chi (if (= dif 0) 
                                          1
                                          (- 1 (chisq-cdf (abs dif)
                                                     (abs (- first-coefs second-coefs)))))))

                          (add-text w 
                                    (strcat 
                                     (format nil "Nested models ~%Difference ~,5g df  ~d p= ~,5f "
                                             (- first-dev second-dev)                             
                                             (abs (- first-coefs second-coefs))
                                                  chi
                                                  )))))
                   (t (add-text w "Non-Nested Models")))
                          ))))))

    (defmeth dev-plot :update-plotcell (&rest args)
      (when (equal (first args) "terms")
            (let* ((numcats (apply '* (send v-log-lin-proto :ncat)))
                   )
            (send self :clear-points)
            (send self :add-points 
                  (iseq (length (send v-log-lin-proto :models-adjusted-list)))
                  (mapcar #'(lambda (obj) (if (= (send obj :num-coefs)
                                                 numcats)
                                              0
                                              (/ (send obj :chi)
                                                 (- numcats
                                                    (send obj :num-coefs)))))
                          (send v-log-lin-proto :models-adjusted-list))
                  :color 'blue)
            (send self :add-lines 
                  (iseq (length (send v-log-lin-proto :models-adjusted-list)))
                  (mapcar #'(lambda (obj) (if (= (send obj :num-coefs)
                                                 numcats)
                                              0
                                              (/ (send obj :chi)
                                                 (- numcats
                                                    (send obj :num-coefs)))))
                          (send v-log-lin-proto :models-adjusted-list)) 
                  :color 'red)
            (send self :adjust-to-data)))
      )
   (defmeth dev-plot :do-select-click (x y m1 m2)
      (call-next-method x y m1 m2)
      (when (and (send self :selection) (= (length (send self :selection)) 1))
            (send v-log-lin-proto :curr-model (select 
                                               (send v-log-lin-proto :models-adjusted-list)
                                               (first (send self :selection))))
                                               )
                                               
      (send (send self :spreadplot-object)
           :update-spreadplot "dev-plot" 0 (send self :selection))
      )

    (defmeth par-plot :update-plotcell (&rest args)
      (when (or (equal (first args) "terms") (equal (first args) "dev-plot"))
            (send self :new-plot)))

(when use-mosaic-plot?
      (mapcar #'(lambda (mp-plot) 
                  (defmeth mp-plot :show-rect-label (i x y show)
                    (let ((dc (send self :draw-color))
                          (bc (send self :back-color))
                          (ch (send self :canvas-height))
                          (cw (send self :canvas-width))
                          (hth (ceiling (- (/ (+ (send self :text-ascent) 
                                                 (send self :text-descent)) 2) 1)))
                          (cellfreqs (send self :cells))
                          (str) (strw) (diff)
                          (colors (send self :color-values))
                          )
                      (send self :draw-mode 'xor)
                      (when (send self :showing-labels)
                            (setf str (select (send self :point-labels) i))
                            (setf strw (send self :text-width str))
                            (setf diff (- (- x (ceiling (/ strw 2))) 
                                          (first (send self :content-rect)) 4))
                            (when (> diff 0) (setf diff 0)) 
                            (send self :draw-text str (- x diff) (+ hth y) 1 0))
                      (send self :draw-text 
                            (format nil "f=~4f" (select cellfreqs i)) 3 (- ch hth) 0 0)
                      (send self :draw-text
                            (format nil "c=~4,1f" (select colors i)) (- cw 3) (- ch hth) 2 0)
                      (send self :draw-color-line (select colors i))
                      (send self :draw-mode 'normal)
                      (send self :back-color bc)
                      (send self :draw-color dc)))
                  
                  )
              (list mp mp-predicted)))



   (setf sp (spread-plot 
              (matrix '(2 4) 
                      (list 
                       terms-in-model-name-list
                       (if use-mosaic-plot? mp-predicted resplot)
                       (if use-mosaic-plot? mp count-residual)
                       obs-list
                       nil
                       (list cook-plot par-plot )
                       dev-plot
                       nil
                       ))
             :span-down (matrix '(2 4) (list 2 1 1 2 0 1 1 0 ))
             :rel-widths (list .6 1 1 .3)
             :local-links t
             :container container))


(setf use-logs-menu-item  
          (send menu-item-proto :new "Show Square Roots" 
                :action #'(lambda () 
                            (send v-log-lin-proto :use-logs?
                                  (if (send v-log-lin-proto :use-logs?) 
                                      nil t))
                            (if (send v-log-lin-proto :use-logs?) 
                                (send use-logs-menu-item :title "Show Raw data")
                                (send use-logs-menu-item :title "Show Square Roots"))
                            (send mp :update-plotcell)
                            (send mp-predicted :update-plotcell))))
    (send
     (send sp :menu)
     :append-items use-logs-menu-item)
    (send v-log-lin-proto :use-logs? nil)
 
    (send sp :show-spreadplot)
    (send sp :supplemental-plot w)
    (defmeth w :close ()
      (send self :hide-window))
    (send w  :update-plotcell "terms" nil nil)
    (send dev-plot  :update-plotcell "terms" nil nil)
    (defmeth sp :refresh ()
      (call-next-method)
      (send w :show-window)
      (send w :top-most t))
    (send w :size 339 75)
    (send w :show-window)
    (send w :top-most t)
    (send cook-plot :linked t)
    (send resplot :linked t)
    (send obs-list :linked t)
    (send par-plot :linked nil)
    (when (not use-mosaic-plot?) (send count-residual :linked t))
    (disable-container)
    ))

    